/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.domain.cloud.ModelFw;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.c.a;
import com.tp_link.eap.monitor.monitor.repo.ModelFwRepository;
import com.tp_link.eap.monitor.monitor.service.f;
import com.tp_link.eap.monitor.monitor.service.impl.ApService;
import com.tp_link.eap.monitor.monitor.service.impl.s;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="modelFwService")
public class ModelFwService
extends com.tp_link.eap.i.a.a<ModelFw>
implements f {
    private static final Logger a = LoggerFactory.getLogger(ModelFwService.class);
    private static final long b = 0x10000000L;
    @Autowired
    private ModelFwRepository c;

    @Override
    public synchronized void refreshModelInfo(ModelFw modelFw) {
        ModelFw modelFw2;
        if (StringUtils.isBlank((String)modelFw.getModelModelVersion())) {
            a.warn("Invalid model information: {}.", (Object)modelFw.toString());
            return;
        }
        if (StringUtils.isBlank((String)modelFw.getEncryptedHwId()) || StringUtils.isBlank((String)modelFw.getEncryptedOemId())) {
            modelFw2 = com.tp_link.eap.monitor.c.a.a(modelFw.getModelModelVersion());
            if (modelFw2 == null) {
                a.warn("Failed to get model information from local map file.");
            } else {
                modelFw = modelFw2;
            }
        }
        if ((modelFw2 = this.c.findByModelModelVersion(modelFw.getModelModelVersion())) == null || StringUtils.isBlank((String)modelFw2.getEncryptedHwId()) || StringUtils.isBlank((String)modelFw2.getEncryptedOemId())) {
            a.debug("Replaces existed modelFw with one new.");
            if (modelFw2 != null) {
                modelFw.setId(modelFw2.getId());
            }
            this.c.save(modelFw);
        } else if (!StringUtils.isBlank((String)modelFw.getEncryptedHwId()) && !StringUtils.isBlank((String)modelFw.getEncryptedOemId())) {
            if (!modelFw2.getEncryptedHwId().equals(modelFw.getEncryptedHwId()) || !modelFw2.getEncryptedOemId().equals(modelFw.getEncryptedOemId())) {
                modelFw.setId(modelFw2.getId());
                this.c.save(modelFw);
            } else {
                if (StringUtils.isBlank((String)modelFw.getId())) {
                    return;
                }
                this.c.save(modelFw);
            }
        }
    }

    @Override
    public synchronized ModelFw getModelInfo(String modelModelVersion) {
        return this.c.findByModelModelVersion(modelModelVersion);
    }

    @Override
    public void refreshModelInfoByAp(Ap ap) {
        ModelFw modelFw;
        String string = ap.getModelModelVersion();
        if (!StringUtils.isBlank((String)string) && (modelFw = com.tp_link.eap.monitor.c.a.a(string)) != null) {
            this.refreshModelInfo(modelFw);
        }
    }

    @Override
    public List<ModelFw> getAll() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.c.findAll());
    }

    @Override
    public List<ModelFw> getByCategory(int category) {
        return this.c.findByCategoryOrderByModelModelVersionAsc(category);
    }

    @Override
    public void deleteAll() {
        this.c.deleteAll();
    }

    @Override
    public void cleanExpiredFw() {
        File[] fileArray;
        File file;
        String string = System.getProperty("eap.home", ".") + File.separatorChar + ApService.a;
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.c.findAll());
        if (list == null || list.size() == 0) {
            com.tp_link.eap.monitor.c.a.d(string);
        }
        if (!(file = new File(string)).exists()) {
            return;
        }
        for (File file2 : fileArray = file.listFiles()) {
            boolean bl = false;
            String string2 = ApService.restoreModelModelVersion(file2.getName());
            for (ModelFw modelFw : list) {
                if (!modelFw.getModelModelVersion().equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            com.tp_link.eap.monitor.c.a.d(file2.getAbsolutePath());
        }
    }

    @Override
    public synchronized void cleanOldEAPFwForSpace() {
        String string = System.getProperty("eap.home", ".") + File.separatorChar + ApService.a;
        long l2 = com.tp_link.eap.monitor.c.a.e(string);
        if (l2 > 0x10000000L) {
            a.info("Used space size for EAP firmware is {}, so clean old firmware to get more space.", (Object)l2);
            ArrayList<File> arrayList = new ArrayList<File>();
            com.tp_link.eap.monitor.c.a.a(string, arrayList);
            arrayList.sort(new s(this));
            for (File file : arrayList) {
                if (l2 <= 0x10000000L) break;
                long l3 = file.length();
                if (!file.delete()) continue;
                l2 -= l3;
            }
            a.info("Current used space size for EAP firmware is {} after clean.", (Object)l2);
        }
    }

    public List<ModelFw> getList(QueryPage queryPage) {
        List<ModelFw> list = this.getList(queryPage, null, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<ModelFw> getList(QueryPage queryPage, QuerySort querySort) {
        List<ModelFw> list = this.getList(queryPage, querySort, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<ModelFw> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<ModelFw> list = this.getList(queryPage, null, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<ModelFw> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<ModelFw> list = this.c.getByFilters(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.c.countByFilters(filters, searchFilters);
    }
}

